/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.entity.ai;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.AxisAlignedBB;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.TrinketsConfig;

public class EnderMoveAI
extends EntityAIFollow {
    private final EntityLiving enderman;
    private final Predicate<EntityLiving> followPredicate;
    private EntityPlayer followingEntity;
    private final double speedModifier;
    private final PathNavigate navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;

    public EnderMoveAI(EntityEnderman entity) {
        super((EntityLiving)entity, 1.0, 6.0f, 16.0f);
        this.enderman = entity;
        this.followPredicate = following -> following != null && this.enderman.getClass() != following.getClass();
        this.speedModifier = 1.0;
        this.navigation = this.enderman.func_70661_as();
        this.stopDistance = 6.0f;
        this.areaSize = 16.0f;
        this.func_75248_a(3);
        if (!(this.enderman.func_70661_as() instanceof PathNavigateGround) && !(this.enderman.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    public boolean func_75250_a() {
        if (TrinketsConfig.SERVER.Items.ENDER_CROWN.Follow) {
            AxisAlignedBB bBox = this.enderman.func_174813_aQ();
            List list = this.enderman.func_130014_f_().func_72872_a(EntityLivingBase.class, bBox.func_72314_b(16.0, 4.0, 16.0));
            if (!list.isEmpty()) {
                for (EntityLivingBase entityliving : list) {
                    if (!(entityliving instanceof EntityPlayer)) continue;
                    boolean tiara = TrinketHelper.AccessoryCheck(entityliving, ModItems.trinkets.TrinketEnderTiara);
                    boolean ability = TrinketHelper.entityHasAbility("ender_queen".toString(), entityliving);
                    if (entityliving.func_82150_aj() || !tiara && !ability) continue;
                    this.followingEntity = (EntityPlayer)entityliving;
                    int count = 0;
                    if (this.followingEntity != null) {
                        List allies = this.enderman.func_130014_f_().func_72872_a(EntityEnderman.class, entityliving.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                        for (EntityEnderman ally : allies) {
                            ++count;
                        }
                    }
                    if (count >= 4) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        int count = 0;
        if (this.followingEntity != null) {
            List allies = this.enderman.func_130014_f_().func_72872_a(EntityEnderman.class, this.followingEntity.func_174813_aQ().func_72314_b(6.0, 4.0, 6.0));
            for (EntityEnderman ally : allies) {
                ++count;
            }
        }
        return this.followingEntity != null && count < 4 && !this.navigation.func_75500_f() && this.enderman.func_70068_e((Entity)this.followingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.enderman.func_184643_a(PathNodeType.WATER);
        this.enderman.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.followingEntity = null;
        this.navigation.func_75499_g();
        this.enderman.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.followingEntity != null && !this.enderman.func_110167_bD()) {
            this.enderman.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.enderman.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                double d0 = this.enderman.field_70165_t - this.followingEntity.field_70165_t;
                double d1 = this.enderman.field_70163_u - this.followingEntity.field_70163_u;
                double d2 = this.enderman.field_70161_v - this.followingEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                    this.navigation.func_75497_a((Entity)this.followingEntity, this.speedModifier);
                } else {
                    this.navigation.func_75499_g();
                    if (d3 <= (double)this.stopDistance) {
                        double d4 = this.followingEntity.field_70165_t - this.enderman.field_70165_t;
                        double d5 = this.followingEntity.field_70161_v - this.enderman.field_70161_v;
                        this.navigation.func_75492_a(this.enderman.field_70165_t - d4, this.enderman.field_70163_u, this.enderman.field_70161_v - d5, this.speedModifier);
                    }
                }
            }
        }
    }
}

